#include <bits/stdc++.h>

#define MAX 221
#define EPS 1e-6
#define MOD 1000000007
#define inf 0x3f3f3f3f
#define llinf 0x3f3f3f3f3f3f3f3f

#define fi first
#define se second
#define pb push_back
#define ende '\n'

#define all(x) (x).begin(), (x).end()
#define rall(x) (x).rbegin(), (x).rend()
#define mset(x, y) memset(&x, (y), sizeof(x))

using namespace std; 

using ll = long long;
using ii = pair<int,int>;

vector<int> graph[MAX];

struct HopcroftKarp {
  int L, R;
  vector<int> dist;
  vector<int> matchL, matchR;

  HopcroftKarp(int L, int R) :
    L(L), R(R), dist(L),
    matchL(L), matchR(R)
  { init(); }

  void init() {
    fill(all(matchL), 0);
    fill(all(matchR), 0);
  }

  bool bfs() {
    queue<int> Q;

    for (int l = 1; l <= L; ++l)
      if (matchL[l] == 0) {
        dist[l] = 0;
        Q.push(l);
      } else {
        dist[l] = inf;
      }

    dist[0] = inf;
    while (!Q.empty()) {
      int l = Q.front(); Q.pop();

      if (dist[l] < dist[0])
        for (auto r : graph[l])
          if (dist[matchR[r]] == inf) {
            dist[matchR[r]] = dist[l] + 1;
            Q.push(matchR[r]);
          }
    }

    return (dist[0] != inf);
  }

  bool dfs(int l) {
    if (l == 0)
      return true;

    for (auto r : graph[l])
      if (dist[matchR[r]] == dist[l] + 1)
        if (dfs(matchR[r])) {
          matchR[r] = l;
          matchL[l] = r;
          return true;
        }

    dist[l] = inf;
    return false;
  }

  int run() {
    int ans = 0;

    while (bfs())
      for (int l = 1; l <= L; ++l)
        if (matchL[l] == 0 && dfs(l))
          ans++;

    return ans;
  }
};

int main() {
  ios::sync_with_stdio(0);
  cin.tie(0);

  int t; cin >> t;
  for (int cas = 1; cas <= t; ++cas) {
    int n; cin >> n;
    vector<vector<int>> mat(n, vector<int>(n));
    for (auto &i : mat)
      for (auto &j : i) 
        cin >> j;

    cout << "Case #" << cas << ": ";
    int ans = 0;
    for (int i = -n; i <= n; ++i) {
      for (int j = 0; j < MAX; ++j)
        graph[j].clear();

      int num = 0;
      for (int j = 0; j < n; ++j)
        for (int k = 0; k < n; ++k)
          if (mat[j][k] == i) {
            num++;
            graph[j + 1].pb(n + k + 1);
          }

      HopcroftKarp hk(n+n+1, n+n+1);
      ans += (num - hk.run());
    }
    cout << ans << ende;
  }

  return 0;
}
